/*
 * Decompiled with CFR 0.152.
 */
package com.mlib.data;

import com.google.gson.JsonElement;
import com.mlib.data.DataList;
import com.mlib.data.ISerializable;
import com.mlib.data.ReaderBlockPos;
import com.mlib.data.ReaderBoolean;
import com.mlib.data.ReaderCustom;
import com.mlib.data.ReaderEnchantment;
import com.mlib.data.ReaderEntityType;
import com.mlib.data.ReaderEnum;
import com.mlib.data.ReaderFloat;
import com.mlib.data.ReaderInteger;
import com.mlib.data.ReaderResourceLocation;
import com.mlib.data.ReaderString;
import com.mlib.data.ReaderUUID;
import com.mlib.data.SerializableHelper;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.enchantment.Enchantment;

public abstract class SerializableList
implements ISerializable {
    final String key;
    ISerializable serializable = null;

    public SerializableList(String key) {
        this.key = key;
    }

    public SerializableList() {
        this(null);
    }

    @Override
    public void read(JsonElement element) {
        JsonElement subelement = SerializableHelper.getReadSubelement(element, this.key);
        if (subelement == null) {
            return;
        }
        this.serializable.read(subelement);
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        this.serializable.write(buffer);
    }

    @Override
    public void read(FriendlyByteBuf buffer) {
        this.serializable.read(buffer);
    }

    @Override
    public void write(Tag tag) {
        Tag subtag = SerializableHelper.getWriteSubtag(tag, this.key, ListTag::new);
        if (subtag == null) {
            return;
        }
        this.serializable.write(subtag);
    }

    @Override
    public void read(Tag tag) {
        Tag subtag = SerializableHelper.getReadSubtag(tag, this.key);
        if (subtag == null) {
            return;
        }
        this.serializable.read(subtag);
    }

    public void defineBlockPos(DataList.Getter<BlockPos> getter, DataList.Setter<BlockPos> setter) {
        this.serializable = new DataList<BlockPos>(getter, setter, new ReaderBlockPos());
    }

    public void defineBoolean(DataList.Getter<Boolean> getter, DataList.Setter<Boolean> setter) {
        this.serializable = new DataList<Boolean>(getter, setter, new ReaderBoolean());
    }

    public <Type extends ISerializable> void defineCustom(DataList.Getter<Type> getter, DataList.Setter<Type> setter, Supplier<Type> newInstance) {
        this.serializable = new DataList<Type>(getter, setter, new ReaderCustom<Type>(newInstance));
    }

    public void defineEnchantment(DataList.Getter<Enchantment> getter, DataList.Setter<Enchantment> setter) {
        this.serializable = new DataList<Enchantment>(getter, setter, new ReaderEnchantment());
    }

    public void defineEntityType(DataList.Getter<EntityType<?>> getter, DataList.Setter<EntityType<?>> setter) {
        this.serializable = new DataList(getter, setter, new ReaderEntityType());
    }

    public <Type extends Enum<?>> void defineEnum(DataList.Getter<Type> getter, DataList.Setter<Type> setter, Supplier<Type[]> values) {
        this.serializable = new DataList<Type>(getter, setter, new ReaderEnum(values));
    }

    public void defineFloat(DataList.Getter<Float> getter, DataList.Setter<Float> setter) {
        this.serializable = new DataList<Float>(getter, setter, new ReaderFloat());
    }

    public void defineInteger(DataList.Getter<Integer> getter, DataList.Setter<Integer> setter) {
        this.serializable = new DataList<Integer>(getter, setter, new ReaderInteger());
    }

    public void defineLocation(DataList.Getter<ResourceLocation> getter, DataList.Setter<ResourceLocation> setter) {
        this.serializable = new DataList<ResourceLocation>(getter, setter, new ReaderResourceLocation());
    }

    public void defineString(DataList.Getter<String> getter, DataList.Setter<String> setter) {
        this.serializable = new DataList<String>(getter, setter, new ReaderString());
    }

    public void defineUUID(DataList.Getter<UUID> getter, DataList.Setter<UUID> setter) {
        this.serializable = new DataList<UUID>(getter, setter, new ReaderUUID());
    }
}

